# 機能設計書 14-設定管理（Configuration Management）

## 概要

本ドキュメントは、TensorFlowの実行時設定（GPUメモリ割り当て、スレッド数、JITコンパイル、デバイスポリシー等）を管理する機能に関する設計書である。`tf.config`名前空間配下の各種設定APIの仕様と動作を詳述する。

### 本機能の処理概要

設定管理機能は、TensorFlowランタイムの動作を制御するための設定APIを提供する。物理/論理デバイスの管理、GPUメモリ成長ポリシー、スレッド並列度、グラフ最適化オプション、TensorFloat-32精度制御、演算決定性制御など、多岐にわたるランタイム設定を統一的なAPIで管理する。

**業務上の目的・背景**：TensorFlowの実行環境はハードウェア構成やユースケースに応じて最適な設定が異なる。GPUメモリの動的割り当て、マルチGPU環境での特定GPUの無効化、混合精度の制御、再現性のための決定性有効化など、環境に応じた柔軟な設定が必要である。

**機能の利用シーン**：モデル学習前のGPUメモリ設定、マルチGPU環境での可視デバイス制御、XLA JITコンパイルの有効化、デバッグ時の演算決定性有効化、パフォーマンスチューニング時のスレッド数調整、Grappler最適化オプションの設定。

**主要な処理内容**：
1. 物理デバイスの列挙・可視性制御（list_physical_devices, set_visible_devices）
2. 論理デバイスの設定・取得（set_logical_device_configuration, list_logical_devices）
3. GPUメモリ成長ポリシーの設定（set_memory_growth）
4. スレッド並列度の設定（intra_op / inter_op parallelism）
5. TensorFloat-32実行制御
6. 演算決定性（op determinism）の有効化
7. ソフトデバイス配置の制御
8. JITコンパイル・Grappler最適化オプションの設定
9. MLIR Bridge有効化/無効化
10. デバイスメモリ情報の取得・リセット

**関連システム・外部連携**：CUDA/cuDNNランタイム（GPU設定）、XLAコンパイラ（JIT設定）、NNAPIデリゲート、MLIRコンパイラ。

**権限による制御**：特になし。ただし、一部の設定（デバイス構成等）はランタイム初期化前にのみ変更可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面に直接関連しない基盤機能である |

## 機能種別

構成管理 / ランタイム制御

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| device_type | string | No | デバイスフィルタ（"CPU", "GPU"等） | 有効なデバイスタイプ文字列 |
| devices | list[PhysicalDevice] | Yes（set_visible_devices） | 可視デバイスリスト | PhysicalDeviceインスタンス |
| device | PhysicalDevice/string | Yes（memory関連） | 対象デバイス | 有効なデバイス指定 |
| enable | bool | Yes（set_memory_growth等） | 有効/無効フラグ | ブール値 |
| num_threads | int | Yes（set_*_parallelism） | スレッド数（0=自動） | 非負整数 |
| enabled | bool/str | Yes（set_optimizer_jit） | JIT設定 | True/"autoclustering"/False |
| options | dict | Yes（set_experimental_options） | 最適化オプション | 有効なキー名 |
| device_policy | str/None | Yes（set_device_policy） | デバイスポリシー | "silent"/"warn"/"explicit"/"silent_for_int32"/None |
| logical_devices | list[LogicalDeviceConfiguration] | Yes（set_logical_device_configuration） | 論理デバイス設定 | LogicalDeviceConfigurationインスタンス |

### 入力データソース

プログラムコード内の設定呼び出し、環境変数（TF_CONFIG等）。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| physical_devices | list[PhysicalDevice] | 物理デバイスリスト |
| logical_devices | list[LogicalDevice] | 論理デバイスリスト |
| memory_info | dict | メモリ使用情報（current, peak） |
| device_details | dict | デバイス詳細情報（device_name, compute_capability） |
| jit_config | str | JIT設定状態 |
| experimental_options | dict | Grappler最適化オプション |

### 出力先

呼び出し元のPythonコンテキスト。設定はTensorFlowランタイムに反映される。

## 処理フロー

### 処理シーケンス

```
1. 設定API呼び出し（例: tf.config.set_memory_growth）
   └─ 引数バリデーション
2. context.context() でEagerContextを取得
   └─ Context APIの対応メソッドに委譲
3. ランタイムへの設定反映
   └─ C++層のランタイム設定を変更
4. 設定結果の返却（取得系APIの場合）
```

### フローチャート

```mermaid
flowchart TD
    A[tf.config API呼び出し] --> B{ランタイム初期化済み?}
    B -->|Yes and 初期化前限定| C[RuntimeError]
    B -->|No or 初期化後可| D[context.context 取得]
    D --> E[Context API に委譲]
    E --> F[C++ ランタイム設定変更]
    F --> G[結果返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 初期化前制約 | set_visible_devices/set_logical_device_configuration/set_memory_growthはランタイム初期化前のみ | RuntimeError |
| BR-02 | Windows GPU警告 | Windows環境ではGPUサポート非対応の警告を表示（TF >= 2.11） | platform.system() == 'Windows' |
| BR-03 | TF32デフォルト有効 | TensorFloat-32はデフォルトで有効 | Ampere以降のGPU |
| BR-04 | ソフト配置デフォルト | Eagerモードではソフト配置が有効、Graphモードでは無効 | 実行モード依存 |
| BR-05 | 決定性トレードオフ | 演算決定性を有効にするとパフォーマンスが低下する | enable_op_determinism |
| BR-06 | メモリ成長制約 | 仮想デバイスが設定されたデバイスにはメモリ成長を設定不可 | set_memory_growth |

### 計算ロジック

特になし（設定の読み書きが主目的）。

## データベース操作仕様

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| RuntimeError | 初期化後変更 | ランタイム初期化後にデバイス構成を変更 | プログラム冒頭で設定する |
| ValueError | 無効デバイス | 存在しないデバイスを指定 | list_physical_devicesで確認 |
| ValueError | 無効ポリシー | 不正なdevice_policy値 | 有効なポリシー値を使用 |
| ValueError | メモリ統計非対応 | CPU等でメモリ情報を取得 | GPU/TPUデバイスのみ使用 |
| InternalError | 不正ポリシー | 内部的に不正なデバイスポリシー | バグとして報告 |

### リトライ仕様

該当なし。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- 設定APIは低頻度呼び出しを想定（プログラム起動時の1回のみ等）
- list_physical_devicesはランタイム初期化をトリガーしない
- list_logical_devicesはランタイム初期化をトリガーする

## セキュリティ考慮事項

- デバイス設定の変更はプログラム全体に影響する
- メモリ成長を無効にした場合、全GPUメモリが確保される

## 備考

- `tf.config.experimental.*`配下のAPIは将来変更される可能性がある
- TensorFloat-32はGPU（Ampere以降）およびTPUに影響する
- op determinism有効化時、tf.dataのパフォーマンスに大きな影響がある

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | context.py | `tensorflow/python/eager/context.py` | Context クラス - 全設定の中央管理 |

**読解のコツ**: config.pyの各関数は基本的に`context.context()`を経由してC++層に設定を伝達する薄いラッパーである。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | config.py | `tensorflow/python/framework/config.py` | tf.config名前空間の各種設定API |

**主要処理フロー**:
1. **31-105行目**: TensorFloat-32実行制御 - _pywrap_tensor_float_32_execution経由
2. **108-159行目**: スレッド並列度設定 - intra_op/inter_opの取得・設定
3. **162-258行目**: JIT/Grappler最適化設定
4. **261-313行目**: ソフトデバイス配置設定
5. **428-470行目**: list_physical_devices - 物理デバイス列挙
6. **545-578行目**: set_visible_devices - 可視デバイス設定
7. **712-766行目**: set_memory_growth - GPUメモリ成長ポリシー
8. **855-924行目**: set_logical_device_configuration - 論理デバイス設定
9. **944-1105行目**: enable_op_determinism - 演算決定性制御

#### Step 3: デバイスポリシーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | config.py | `tensorflow/python/framework/config.py` | get/set_device_policy（316-387行目） |

**主要処理フロー**:
- **316-341行目**: get_device_policy - 現在のポリシーを文字列で返却
- **344-387行目**: set_device_policy - 文字列からContext定数への変換・設定

### プログラム呼び出し階層図

```
tf.config.* API
    |
    +-- tf.config.list_physical_devices(device_type)
    |       +-- context.context().list_physical_devices(device_type)
    |
    +-- tf.config.set_visible_devices(devices, device_type)
    |       +-- context.context().set_visible_devices(devices, device_type)
    |
    +-- tf.config.experimental.set_memory_growth(device, enable)
    |       +-- context.context().set_memory_growth(device, enable)
    |
    +-- tf.config.set_logical_device_configuration(device, logical_devices)
    |       +-- context.context().set_logical_device_configuration(...)
    |
    +-- tf.config.threading.set_intra_op_parallelism_threads(num)
    |       +-- context.context().intra_op_parallelism_threads = num
    |
    +-- tf.config.experimental.enable_tensor_float_32_execution(enabled)
    |       +-- _pywrap_tensor_float_32_execution.enable(enabled)
    |
    +-- tf.config.experimental.enable_op_determinism()
            +-- _pywrap_determinism.enable(True)
```

### データフロー図

```
[入力]                      [処理]                     [出力]

Python設定API呼び出し ---> config.py (薄いラッパー) ---> ランタイム設定反映
                            |                              |
                            v                              v
                      context.context()             C++ ランタイム
                            |
                            v
                      _pywrap_* バインディング
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| config.py | `tensorflow/python/framework/config.py` | ソース | 設定APIの主要実装 |
| context.py | `tensorflow/python/eager/context.py` | ソース | 設定の中央管理（Contextクラス） |
| _pywrap_determinism | `tensorflow/python/util/_pywrap_determinism` | C++バインディング | 演算決定性制御 |
| _pywrap_tensor_float_32_execution | `tensorflow/python/util/_pywrap_tensor_float_32_execution` | C++バインディング | TF32精度制御 |
| deprecation.py | `tensorflow/python/util/deprecation.py` | ソース | 非推奨API管理 |
